<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AbilityRole extends Model 
{

    protected $table = 'ability_role';
    public $timestamps = false;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('role_id');
    protected $visible = array('role_id');

    public function role()
    {
        return $this->belongsTo('App\Models\Role');
    }

    public function ability()
    {
        return $this->belongsTo('App\Models\Ability');
    }

}